/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.surfacebuilder;

import com.mojang.serialization.Codec;
import corgiaoc.byg.common.world.surfacebuilder.config.PointedSBConfig;
import corgiaoc.byg.util.noise.fastnoise.FNVector3f;
import corgiaoc.byg.util.noise.fastnoise.FastNoise;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class PointedSB
extends SurfaceBuilder<PointedSBConfig> {
    public static FastNoise noiseGen = null;
    public static FastNoise noiseGen3D = null;

    public PointedSB(Codec<PointedSBConfig> codec) {
        super(codec);
    }

    public void apply(Random random, IChunk chunkIn, Biome biomeIn, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, PointedSBConfig config) {
        this.func_205548_a(random.nextLong());
        int xPos = x & 0xF;
        int zPos = z & 0xF;
        BlockPos.Mutable mutable = new BlockPos.Mutable(xPos, 0, zPos);
        FNVector3f fnVector3f = new FNVector3f(x, 0.0f, z);
        noiseGen.GradientPerturb(fnVector3f);
        float sampleNoise = noiseGen.GetNoise(fnVector3f.x, fnVector3f.z);
        int groundLevel = chunkIn.func_201576_a(Heightmap.Type.OCEAN_FLOOR_WG, x, z);
        if ((double)sampleNoise < 0.43) {
            int valueToReverse = (int)Math.abs((double)((int)((double)sampleNoise * 645.0)) * 1.8);
            int topHeight = (int)((double)valueToReverse - Math.abs((double)(-sampleNoise) * 645.0 * 1.8 - (double)valueToReverse) + 598.5);
            if ((topHeight = PointedSB.redistribute(topHeight, groundLevel, config.getSpikeHeight())) > groundLevel) {
                mutable.func_189534_c(Direction.UP, topHeight);
                for (int yPos = topHeight; yPos >= groundLevel; --yPos) {
                    if (chunkIn.func_180495_p((BlockPos)mutable).func_196958_f() && mutable.func_177956_o() <= chunkIn.func_217301_I()) {
                        if (yPos == topHeight) {
                            chunkIn.func_177436_a((BlockPos)mutable, config.getSpikeTopBlockProvider().func_225574_a_(random, (BlockPos)mutable), false);
                        } else {
                            chunkIn.func_177436_a((BlockPos)mutable, config.getSpikeProvider().func_225574_a_(random, (BlockPos)mutable), false);
                        }
                    }
                    mutable.func_189536_c(Direction.DOWN);
                }
            }
        } else {
            SurfaceBuilder.field_215396_G.func_205610_a_(random, chunkIn, biomeIn, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)new SurfaceBuilderConfig(config.func_204108_a(), config.func_204109_b(), config.func_204109_b()));
        }
    }

    public void func_205548_a(long seed) {
        if (noiseGen == null) {
            noiseGen = new FastNoise((int)seed);
            noiseGen.SetFractalType(FastNoise.FractalType.RigidMulti);
            noiseGen.SetNoiseType(FastNoise.NoiseType.SimplexFractal);
            noiseGen.SetGradientPerturbAmp(5.0f);
            noiseGen.SetFractalOctaves(1);
            noiseGen.SetFractalGain(0.3f);
            noiseGen.SetFrequency(0.02f);
        }
        if (noiseGen3D == null) {
            noiseGen3D = new FastNoise((int)seed);
            noiseGen3D.SetNoiseType(FastNoise.NoiseType.Simplex);
            noiseGen3D.SetFractalGain(0.006f);
            noiseGen3D.SetFrequency(0.7f);
        }
    }

    private static int redistribute(float height, float groundLevel, int configHeight) {
        float halfG = groundLevel * 0.5f;
        height = (height - 125.0f - halfG) / 80.0f;
        float sigmoid = height / (1.0f + Math.abs(height));
        return (int)(((float)configHeight - groundLevel) * sigmoid + halfG + 125.0f);
    }
}

